/*****************************************************************************
 *   SE95.h:  SE95 temperature sensor header file for NXP LPC29xx Family
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#ifndef __SE95_H 
#define __SE95_H

/* SE95 Registers pointer values*/
#define SE95_TEMP		0
#define SE95_CONF		1
#define SE95_THYST		2
#define SE95_TOS		3
#define SE95_ID			5

/* SE95 */
#define SE95_BUSY		1
#define SE95_DONE		0

/* SE95 Configuration register bit settings */
#define SE95_CONF_SHUT		(1<<0)		/* SHUTDOWN 		0: normal, 1: shutdown*/
#define SE95_CONF_OS_OP		(1<<1)		/* OS_COMP_INT 	0: OS comparator, 1: OS interrupt */
#define SE95_CONF_OS_POL	(1<<2)		/* OS_POL				0: OS active HIGH 1: OS active LOW */
#define SE95_CONF_OS_QUE1	(0<<3)		/* OS_F_QUE			Queue value 1 */
#define SE95_CONF_OS_QUE2	(1<<3)		/* OS_F_QUE			Queue value 2 */
#define SE95_CONF_OS_QUE4	(2<<3)		/* OS_F_QUE			Queue value 4 */
#define SE95_CONF_OS_QUE6	(3<<3)		/* OS_F_QUE			Queue value 6 */

BYTE SE95_init(void);
BYTE SE95_read_temp(void);

#endif // end of __SE95_H
